/*
 * Decompiled with CFR 0.152.
 */
package com.fsi.email;

import com.ptc.core.lwc.server.PersistableAdapter;
import com.ptc.netmarkets.model.NmOid;
import com.ptc.netmarkets.util.beans.NmURLFactoryBean;
import com.ptc.netmarkets.util.misc.NetmarketURL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import wt.change2.ChangeActivityIfc;
import wt.change2.ChangeException2;
import wt.change2.ChangeHelper2;
import wt.change2.ChangeIssueIfc;
import wt.change2.ChangeOrder2;
import wt.change2.ChangeOrderIfc;
import wt.change2.ChangeRecord2;
import wt.change2.ChangeRequestIfc;
import wt.change2.ChangeReviewIfc;
import wt.change2.ChangeReviewItemLink;
import wt.change2.Changeable2;
import wt.change2.RelevantRequestData2;
import wt.change2.ReportedAgainst;
import wt.change2.WTChangeActivity2;
import wt.change2.WTChangeIssue;
import wt.change2.WTChangeRequest2;
import wt.change2.WTChangeReview;
import wt.change2.WTVariance;
import wt.doc.WTDocument;
import wt.epm.EPMDocument;
import wt.fc.Persistable;
import wt.fc.QueryResult;
import wt.fc.WTObject;
import wt.lifecycle.LifeCycleException;
import wt.lifecycle.LifeCycleHelper;
import wt.lifecycle.LifeCycleManaged;
import wt.lifecycle.LifeCycleTemplateReference;
import wt.lifecycle.State;
import wt.lifecycle.Transition;
import wt.maturity.MaturityException;
import wt.maturity.MaturityHelper;
import wt.maturity.Promotable;
import wt.maturity.PromotionNotice;
import wt.maturity.PromotionTarget;
import wt.part.WTPart;
import wt.type.TypedUtilityServiceHelper;
import wt.util.WTException;

public class EmailCustomHelper {
    private final Logger LOG = Logger.getLogger("com.fsi.emailcustom");

    public String getChangeableEmailTable(WTObject primaryBusinessObject, String attributes, String allowedTypes) {
        ArrayList<String> rows = new ArrayList<String>();
        String[] attributes_array = attributes.split(",");
        List<String> attributeNames = Arrays.asList(attributes_array);
        String[] allowedTypes_array = allowedTypes.trim().toLowerCase().split("\\s*,\\s*");
        List<String> allowedTypeNames = Arrays.asList(allowedTypes_array);
        LinkedHashMap<WTObject, WTObject> changeables = this.getChangeables(primaryBusinessObject);
        Set<WTObject> changeablesKeys = changeables.keySet();
        for (WTObject changable : changeablesKeys) {
            WTObject changeRecord = changeables.get(changable);
            LinkedHashMap<String, String> listOfAttributes = new LinkedHashMap<String, String>();
            String compType = this.getObjectType(changable);
            boolean isAllowed = false;
            if (allowedTypeNames.contains("all")) {
                isAllowed = true;
            }
            if (!allowedTypeNames.contains("all")) {
                for (String allowedTypeName : allowedTypeNames) {
                    if (!compType.toLowerCase().contains(allowedTypeName)) continue;
                    isAllowed = true;
                    break;
                }
            }
            if (!isAllowed) continue;
            for (String attributeName : attributeNames) {
                String url;
                boolean isIBA = true;
                if (attributeName.equalsIgnoreCase("Name")) {
                    String compName = this.getObjectName(changable);
                    url = this.getObjectURL(changable);
                    listOfAttributes.put("Name", "<a href=" + url + ">" + compName + "</a>");
                    isIBA = false;
                }
                if (attributeName.equalsIgnoreCase("Number")) {
                    String compNumber = this.getObjectNumber(changable);
                    url = this.getObjectURL(changable);
                    listOfAttributes.put("Number", "<a href=" + url + ">" + compNumber + "</a>");
                    isIBA = false;
                }
                if (attributeName.equalsIgnoreCase("State")) {
                    String compState = this.getObjectState(changable);
                    listOfAttributes.put("State", compState);
                    isIBA = false;
                }
                if (attributeName.equalsIgnoreCase("Revision")) {
                    String compRev = this.getObjectRevision(changable);
                    listOfAttributes.put("Revision", compRev);
                    isIBA = false;
                }
                if (attributeName.equalsIgnoreCase("Type")) {
                    String reportType = this.getObjectTypeName(compType);
                    listOfAttributes.put("Type", reportType);
                    isIBA = false;
                }
                if (attributeName.equalsIgnoreCase("Comment")) {
                    String comment = this.getChangableRecordComment(changeRecord);
                    listOfAttributes.put("Comment", comment);
                    isIBA = false;
                }
                if (attributeName.equalsIgnoreCase("Transition")) {
                    String targetTransition = this.getChangableRecordTargetTransition(changeRecord);
                    listOfAttributes.put("Transition", targetTransition);
                    isIBA = false;
                }
                if (!isIBA) continue;
                try {
                    PersistableAdapter attr = new PersistableAdapter((Persistable)changable, null, Locale.US, null);
                    attr.load(new String[]{attributeName});
                    String attributeValue = (String)attr.get(attributeName);
                    listOfAttributes.put(attributeName, attributeValue);
                }
                catch (WTException e) {
                    listOfAttributes.put(attributeName, " ");
                    e.printStackTrace();
                }
            }
            Set keys = listOfAttributes.keySet();
            String row = "<tr>";
            for (String name : keys) {
                String value = (String)listOfAttributes.get(name);
                row = String.valueOf(row) + "<td>" + value + "</td>";
            }
            row = String.valueOf(row) + "</tr>";
            rows.add(row);
        }
        String header = "<thead><tr>";
        for (String headerName : attributeNames) {
            header = String.valueOf(header) + "<td>" + headerName + "</td>";
        }
        header = String.valueOf(header) + "</tr></thead>";
        String table = "<table border=\"1\" cellpadding=\"5\" style=\"text-align:center\">" + header + "<tbody>";
        for (String rowInfo : rows) {
            table = String.valueOf(table) + rowInfo;
        }
        table = String.valueOf(table) + "</tbody></table>";
        return table;
    }

    public LinkedHashMap<WTObject, WTObject> getChangeables(WTObject primaryBusinessObject) {
        WTObject changable;
        ChangeRecord2 changeRecord;
        QueryResult qrResultingObjects;
        LinkedHashMap<WTObject, WTObject> changeableRecordes = new LinkedHashMap<WTObject, WTObject>();
        if (primaryBusinessObject instanceof ChangeOrder2) {
            try {
                qrResultingObjects = ChangeHelper2.service.getChangeablesAfter((ChangeOrderIfc)primaryBusinessObject, false);
                while (qrResultingObjects.hasMoreElements()) {
                    changeRecord = (ChangeRecord2)qrResultingObjects.nextElement();
                    changable = (WTObject)changeRecord.getChangeable2();
                    changeableRecordes.put(changable, (WTObject)changeRecord);
                }
            }
            catch (ChangeException2 e) {
                this.LOG.log(Level.SEVERE, e.getMessage(), e);
            }
            catch (WTException e) {
                this.LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (primaryBusinessObject instanceof WTChangeReview) {
            try {
                qrResultingObjects = ChangeHelper2.service.getChangeables((ChangeReviewIfc)primaryBusinessObject, false);
                while (qrResultingObjects.hasMoreElements()) {
                    changeRecord = (ChangeReviewItemLink)qrResultingObjects.nextElement();
                    changable = (WTObject)changeRecord.getChangeable2();
                    changeableRecordes.put(changable, (WTObject)changeRecord);
                }
            }
            catch (ChangeException2 e) {
                this.LOG.log(Level.SEVERE, e.getMessage(), e);
            }
            catch (WTException e) {
                this.LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        boolean cfr_ignored_0 = primaryBusinessObject instanceof WTVariance;
        if (primaryBusinessObject instanceof WTChangeIssue || primaryBusinessObject instanceof WTVariance) {
            try {
                qrResultingObjects = ChangeHelper2.service.getChangeables((ChangeIssueIfc)primaryBusinessObject, false);
                while (qrResultingObjects.hasMoreElements()) {
                    changeRecord = (ReportedAgainst)qrResultingObjects.nextElement();
                    changable = (WTObject)changeRecord.getChangeable2();
                    changeableRecordes.put(changable, (WTObject)changeRecord);
                }
            }
            catch (ChangeException2 e) {
                this.LOG.log(Level.SEVERE, e.getMessage(), e);
            }
            catch (WTException e) {
                this.LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (primaryBusinessObject instanceof WTChangeRequest2) {
            try {
                qrResultingObjects = ChangeHelper2.service.getChangeables((ChangeRequestIfc)primaryBusinessObject, false);
                while (qrResultingObjects.hasMoreElements()) {
                    changeRecord = (RelevantRequestData2)qrResultingObjects.nextElement();
                    changable = (WTObject)changeRecord.getChangeable2();
                    changeableRecordes.put(changable, (WTObject)changeRecord);
                }
            }
            catch (ChangeException2 e) {
                this.LOG.log(Level.SEVERE, e.getMessage(), e);
            }
            catch (WTException e) {
                this.LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (primaryBusinessObject instanceof WTChangeActivity2) {
            try {
                qrResultingObjects = ChangeHelper2.service.getChangeablesAfter((ChangeActivityIfc)primaryBusinessObject, false);
                while (qrResultingObjects.hasMoreElements()) {
                    changeRecord = (ChangeRecord2)qrResultingObjects.nextElement();
                    changable = (WTObject)changeRecord.getChangeable2();
                    changeableRecordes.put(changable, (WTObject)changeRecord);
                }
            }
            catch (ChangeException2 e) {
                this.LOG.log(Level.SEVERE, e.getMessage(), e);
            }
            catch (WTException e) {
                this.LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (primaryBusinessObject instanceof PromotionNotice) {
            try {
                qrResultingObjects = MaturityHelper.service.getPromotionTargets((PromotionNotice)primaryBusinessObject, false);
                while (qrResultingObjects.hasMoreElements()) {
                    PromotionTarget promationTarget = (PromotionTarget)qrResultingObjects.nextElement();
                    String comment = promationTarget.getDescription();
                    Promotable changable2 = promationTarget.getPromotable();
                    changeableRecordes.put((WTObject)changable2, (WTObject)promationTarget);
                }
            }
            catch (MaturityException e) {
                this.LOG.log(Level.SEVERE, e.getMessage(), e);
            }
            catch (WTException e) {
                this.LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return changeableRecordes;
    }

    public String getChangableRecordComment(WTObject record) {
        if (record instanceof ChangeRecord2) {
            ChangeRecord2 changeRecord = (ChangeRecord2)record;
            return changeRecord.getDescription();
        }
        if (record instanceof PromotionTarget) {
            PromotionTarget changeRecord = (PromotionTarget)record;
            return changeRecord.getDescription();
        }
        if (record instanceof ChangeReviewItemLink) {
            ChangeReviewItemLink changeItemLink = (ChangeReviewItemLink)record;
            return changeItemLink.getDescription();
        }
        if (record instanceof ReportedAgainst) {
            ReportedAgainst reportedAgainst = (ReportedAgainst)record;
            return reportedAgainst.getDescription();
        }
        if (record instanceof RelevantRequestData2) {
            RelevantRequestData2 relevantRequestData = (RelevantRequestData2)record;
            return relevantRequestData.getDescription();
        }
        return null;
    }

    public String getTargetStateFromTransition(WTObject object, String transitionName) {
        Iterator setIter;
        Set targetStates;
        LifeCycleTemplateReference lctr;
        State currentState;
        Transition transition = Transition.toTransition((String)transitionName);
        if (object instanceof WTPart) {
            WTPart wtpart = (WTPart)object;
            currentState = wtpart.getLifeCycleState();
            lctr = wtpart.getLifeCycleTemplate();
            try {
                Enumeration enumeration = LifeCycleHelper.service.findPredecessorStates((LifeCycleManaged)wtpart);
            }
            catch (LifeCycleException e1) {
                e1.printStackTrace();
            }
            catch (WTException e1) {
                e1.printStackTrace();
            }
            try {
                targetStates = LifeCycleHelper.service.navigate(lctr, currentState, transition, false);
                setIter = targetStates.iterator();
                if (setIter.hasNext()) {
                    State targetState = (State)setIter.next();
                    String targetStateName = targetState.toString();
                    return targetStateName;
                }
            }
            catch (WTException e) {
                this.LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (object instanceof EPMDocument) {
            EPMDocument epmDoc = (EPMDocument)object;
            currentState = epmDoc.getLifeCycleState();
            lctr = epmDoc.getLifeCycleTemplate();
            try {
                targetStates = LifeCycleHelper.service.navigate(lctr, currentState, transition, false);
                setIter = targetStates.iterator();
                if (setIter.hasNext()) {
                    State targetState = (State)setIter.next();
                    String targetStateName = targetState.toString();
                    return targetStateName;
                }
            }
            catch (WTException e) {
                this.LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (object instanceof WTDocument) {
            WTDocument wtdoc = (WTDocument)object;
            currentState = wtdoc.getLifeCycleState();
            lctr = wtdoc.getLifeCycleTemplate();
            try {
                targetStates = LifeCycleHelper.service.navigate(lctr, currentState, transition, false);
                setIter = targetStates.iterator();
                if (setIter.hasNext()) {
                    State targetState = (State)setIter.next();
                    String targetStateName = targetState.toString();
                    return targetStateName;
                }
            }
            catch (WTException e) {
                this.LOG.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return null;
    }

    public String getChangableRecordTargetTransition(WTObject record) {
        if (record instanceof ChangeRecord2) {
            ChangeRecord2 changeRecord = (ChangeRecord2)record;
            Changeable2 object = changeRecord.getChangeable2();
            if (object instanceof WTPart) {
                this.getTargetStateFromTransition((WTObject)((WTPart)object), "change");
            }
            return changeRecord.getTargetTransition().toString();
        }
        if (record instanceof PromotionTarget) {
            PromotionTarget changeRecord = (PromotionTarget)record;
            return "Promote";
        }
        return null;
    }

    public String getObjectName(WTObject object) {
        if (object instanceof WTDocument) {
            return ((WTDocument)object).getName();
        }
        if (object instanceof EPMDocument) {
            return ((EPMDocument)object).getName();
        }
        if (object instanceof WTPart) {
            return ((WTPart)object).getName();
        }
        return null;
    }

    public String getObjectNumber(WTObject object) {
        if (object instanceof WTDocument) {
            return ((WTDocument)object).getNumber();
        }
        if (object instanceof EPMDocument) {
            return ((EPMDocument)object).getNumber();
        }
        if (object instanceof WTPart) {
            return ((WTPart)object).getNumber();
        }
        return null;
    }

    public String getObjectRevision(WTObject object) {
        if (object instanceof WTDocument) {
            return ((WTDocument)object).getVersionIdentifier().getValue();
        }
        if (object instanceof EPMDocument) {
            return ((EPMDocument)object).getVersionIdentifier().getValue();
        }
        if (object instanceof WTPart) {
            return ((WTPart)object).getVersionIdentifier().getValue();
        }
        return null;
    }

    public String getObjectType(WTObject object) {
        try {
            return TypedUtilityServiceHelper.service.getTypeIdentifier((Object)object).toString();
        }
        catch (WTException e) {
            this.LOG.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    public String getObjectTypeName(String typeFullName) {
        int lastIndexOfDot = typeFullName.lastIndexOf(".");
        if (typeFullName.contains(".")) {
            return typeFullName.substring(lastIndexOfDot + 1);
        }
        return typeFullName;
    }

    public String getObjectState(WTObject object) {
        if (object instanceof WTDocument) {
            return ((WTDocument)object).getState().toString();
        }
        if (object instanceof EPMDocument) {
            return ((EPMDocument)object).getState().toString();
        }
        if (object instanceof WTPart) {
            return ((WTPart)object).getState().toString();
        }
        return null;
    }

    public String getObjectURL(WTObject obj) {
        String url = null;
        try {
            String className = obj.getClass().getName();
            NmOid oid = new NmOid(className, obj.getPersistInfo().getObjectIdentifier());
            NmURLFactoryBean bean = new NmURLFactoryBean();
            url = NetmarketURL.buildURL((NmURLFactoryBean)bean, (String)"object", (String)"view", (NmOid)oid);
            return url;
        }
        catch (WTException e) {
            this.LOG.log(Level.SEVERE, e.getMessage(), e);
            return url;
        }
    }
}

